﻿Option Strict Off
Option Explicit On

<System.Runtime.InteropServices.ProgId("ODatabase_NET.ODatabase")> Public Class ODatabase

    Public ds As odaba.DataSource
    Public db As odaba.Database
    Public dbo As odaba.ObjectSpace
    Public index As Integer
    Public stati As Integer
    Public Function Open(ByRef inifile As String, ByRef section As String) As Boolean

        Dim location As String
        Dim language As odaba.Option

        Open = True
        location = " (inifile='" & inifile & "', section='" & section & "') "

        odaba.Application.initialize(inifile, section, odaba.ApplicationTypes.ConsoleApplication)

        ds = New odaba.DataSource
        ds.open(section)

        dbo = ds.objectSpace
        db = ds.database
        If dbo Is Nothing Or Not dbo.isValid Then
            MsgBox("DataSource" & location & "could not be opened")
            Open = False
        End If

        language = New odaba.Option("DSC_Language")
        If language.toString() = "" Then
            language.assign("English")
        End If
    End Function

    Public Function Close() As Boolean

        'UPGRADE_NOTE: Object odaba may not be destroyed until it is garbage collected. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1029"'
        If Not IsNothing(db) Then
            db.close()
        End If
        If Not IsNothing(dbo) Then
            dbo.close()
        End If
        If Not IsNothing(ds) Then
            ds.close()
        End If

        Close = True

    End Function
    Public Function GetOption(ByRef opt_name As String) As String
        Dim opt As odaba.Option
        opt = New odaba.Option(opt_name)
        GetOption = opt.toString()
    End Function
    Public Function GetProperty(ByRef ph As OProperty, Optional ByRef prop_path As String = "") As OProperty

        Dim oprop As OProperty
        Dim cond As Boolean

        oprop = New OProperty
        cond = False
        If prop_path <> "" Then
            If ph Is Nothing Then
                cond = oprop.Open(dbo, prop_path, odaba.AccessModes.Read)
            Else
                cond = oprop.Open(ph, prop_path)
            End If
        End If
        If cond Then
            GetProperty = oprop
        Else
            MsgBox("Could not open property handle for '" & prop_path & "'")
            GetProperty = Nothing
        End If

    End Function
End Class
<System.Runtime.InteropServices.ProgId("OProperty_NET.OProperty")> Public Class OProperty
    Public prop As odaba.Property
    Public Function Count() As Integer
        Count = prop.count
    End Function
    Public Function Open(ByRef oprop As OProperty, ByVal path As String) As Boolean
        prop = New odaba.Property(oprop.prop, path)
        Open = True
    End Function
    Private Function Open(ByRef oprop As odaba.Property, ByVal path As String) As Boolean
        prop = New odaba.Property(oprop, path)
        Open = True
    End Function
    Public Function Open(ByRef db As odaba.ObjectSpace, ByVal osi_path As String, ByVal accmode As odaba.AccessModes) As Boolean
        prop = New odaba.Property(db, osi_path, accmode)
        Open = True
    End Function
    Public Function Read(ByRef key As String) As Boolean
        Dim skey As New odaba.Key(key)
        Read = False
        If prop.tryGet(skey) Then
            Read = True
        End If
    End Function
    Public Function Read(ByVal num As Integer) As Boolean
        Read = False
        If prop.tryGet(num) Then
            Read = True
        End If
    End Function
    Public Function ReadFirst(Optional ByVal read_opt As Boolean = True) As Boolean
        ReadFirst = prop.first(read_opt)
    End Function
    Public Function ReadLast(Optional ByVal read_opt As Boolean = True) As Boolean
        ReadLast = prop.last(read_opt)
    End Function
    Public Function ReadNext(Optional ByVal read_opt As Boolean = True) As Boolean
        ReadNext = prop.next(read_opt)
    End Function
    Public Function ReadPrevious(Optional ByVal read_opt As Boolean = True) As Boolean
        ReadPrevious = prop.next(read_opt)
    End Function
    Public Function OProperty(ByRef path As String) As OProperty
        Dim oprop As New OProperty

        If oprop.Open(prop, path) Then
            OProperty = oprop
        Else
            OProperty = Nothing
        End If
    End Function
    Public Function OValue(ByRef path As String) As OValue
        Dim oval As New OValue
        If oval.Open(prop, path) Then
            OValue = oval
        Else
            OValue = Nothing
        End If
    End Function
    Public Function Top() As Boolean
        prop.top()
        Top = True
    End Function
    Public Function ODABAProperty() As odaba.Property
        ODABAProperty = prop
    End Function
End Class
<System.Runtime.InteropServices.ProgId("OValue_NET.OValue")> Public Class OValue
    Public value As odaba.Value
    Public Function Open(ByRef oprop As OProperty) As Boolean
        value = oprop.prop.value()
        Open = True
    End Function
    Private Function Open(ByRef prop As odaba.Property) As Boolean
        value = prop.value()
        Open = True
    End Function
    Public Function Open(ByRef oprop As OProperty, ByRef path As String) As Boolean
        value = oprop.prop.value(path)
        Open = True
    End Function
    Public Function Open(ByRef prop As odaba.Property, ByRef path As String) As Boolean
        value = prop.value(path)
        Open = True
    End Function
    Public Function AsBoolean() As Boolean
        AsBoolean = False
        If AutoSelect() Then
            AsBoolean = value.toBool
        End If
    End Function
    Public Function AsInteger() As Integer
        AsInteger = 0
        If AutoSelect() Then
            AsInteger = value.toInteger
        End If
    End Function
    Public Function AsPlainText() As String
        AsPlainText = ""
        If AutoSelect() Then
            AsPlainText = value.toString.toPlainText
        End If
    End Function
    Public Function AsString() As String
        AsString = ""
        If AutoSelect() Then
            AsString = value.toString
        End If
    End Function
    Public Function AutoSelect() As Boolean
        AutoSelect = False
        value.property.autoSelect()
        If value.property.selected Then
            AutoSelect = True
        End If
    End Function
End Class
